/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.effect;

import de.teamlapen.vampirism.entity.GhostEntity;
import java.util.Comparator;
import java.util.List;
import net.grid.vampiresdelight.common.VDConfiguration;
import net.grid.vampiresdelight.common.registry.VDEffects;
import net.grid.vampiresdelight.common.registry.VDParticleTypes;
import net.grid.vampiresdelight.common.registry.VDSounds;
import net.grid.vampiresdelight.common.utility.VDEntityUtils;
import net.grid.vampiresdelight.common.utility.VDHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlessingEffect
extends MobEffect {
    public BlessingEffect() {
        super(MobEffectCategory.BENEFICIAL, FastColor.ARGB32.m_13660_((int)100, (int)250, (int)218, (int)94));
    }

    public void m_6742_(@NotNull LivingEntity entity, int amplifier) {
        if (!VDHelper.isVampire((Entity)entity)) {
            BlessingEffect.resistUnholySpirits((LevelAccessor)entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), amplifier);
        } else {
            entity.m_21195_((MobEffect)VDEffects.BLESSING.get());
        }
    }

    public static void resistUnholySpirits(LevelAccessor world, double x, double y, double z, int amplifier) {
        Vec3 center = new Vec3(x, y, z);
        List unsortedEntityFound = world.m_6443_(LivingEntity.class, new AABB(center, center).m_82400_(5.0 * (double)(amplifier + 1)), e -> true);
        List<LivingEntity> sortedEntitiesFound = unsortedEntityFound.stream().sorted(Comparator.comparingDouble(t -> t.m_20238_(center))).toList();
        for (LivingEntity livingEntity : sortedEntitiesFound) {
            double entityX = livingEntity.m_20185_();
            double entityY = livingEntity.m_20186_();
            double entityZ = livingEntity.m_20189_();
            if (!(livingEntity instanceof Phantom) && (!(livingEntity instanceof GhostEntity) || !((Boolean)VDConfiguration.BLESSING_HELPS_AGAINST_GHOSTS.get()).booleanValue()) || livingEntity.m_20088_().m_135388_()) continue;
            livingEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            Level level = (Level)world;
            level.m_6263_(null, entityX, entityY, entityZ, (SoundEvent)VDSounds.TRIANGLE.get(), SoundSource.NEUTRAL, 0.4f, level.f_46441_.m_188501_() * 0.5f);
            int amount = livingEntity instanceof Phantom ? livingEntity.m_217043_().m_216339_(18, 25) : livingEntity.m_217043_().m_216339_(4, 10);
            VDEntityUtils.spawnBlessingParticlesAroundEntity((ParticleOptions)VDParticleTypes.BLESSING.get(), livingEntity, amount);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

