/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.effect;

import com.google.common.collect.ImmutableSet;
import net.grid.vampiresdelight.common.VDConfiguration;
import net.grid.vampiresdelight.common.utility.VDEntityUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.stats.Stats;
import net.minecraft.util.FastColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;

public class ClothesDissolvingEffect
extends MobEffect {
    private static final ImmutableSet<ArmorMaterial> FULLY_BREAKABLE_ARMOR = ImmutableSet.of((Object)ArmorMaterials.LEATHER, (Object)ArmorMaterials.CHAIN, (Object)ArmorMaterials.GOLD);

    public ClothesDissolvingEffect() {
        super(MobEffectCategory.HARMFUL, FastColor.ARGB32.m_13660_((int)100, (int)206, (int)177, (int)128));
    }

    public void m_6742_(@NotNull LivingEntity livingEntity, int amplifier) {
        ItemStack[] armor;
        for (ItemStack stack : armor = new ItemStack[]{livingEntity.m_6844_(EquipmentSlot.HEAD), livingEntity.m_6844_(EquipmentSlot.CHEST), livingEntity.m_6844_(EquipmentSlot.LEGS), livingEntity.m_6844_(EquipmentSlot.FEET)}) {
            ArmorItem armorItem;
            int durability;
            int damagePerTick = this.getDamagePerTick(stack);
            if (damagePerTick < (durability = stack.m_41776_() - stack.m_41773_())) {
                stack.m_41721_(stack.m_41773_() + damagePerTick);
                continue;
            }
            Item item = stack.m_41720_();
            if (!(item instanceof ArmorItem) || !FULLY_BREAKABLE_ARMOR.contains((Object)(armorItem = (ArmorItem)item).m_40401_()) || !((Boolean)VDConfiguration.ARMOR_DISSOLVES_FULLY.get()).booleanValue()) continue;
            stack.m_41774_(1);
            if (!(livingEntity instanceof Player)) continue;
            ((Player)livingEntity).m_36246_(Stats.f_12983_.m_12902_((Object)stack.m_41720_()));
        }
        VDEntityUtils.spawnParticlesAroundEntity((ParticleOptions)ModParticleTypes.STEAM.get(), livingEntity, livingEntity.m_217043_().m_216339_(3, 8), 0.015, -0.5);
    }

    public int getDamagePerTick(ItemStack stack) {
        int maxDamage = stack.m_41776_();
        int damageDivider = 90;
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            int n = damageDivider = FULLY_BREAKABLE_ARMOR.contains((Object)armorItem.m_40401_()) && (Boolean)VDConfiguration.ARMOR_DISSOLVES_FULLY.get() != false ? 15 : 80;
            if (armorItem.getAllEnchantments(stack).containsKey(Enchantments.f_44986_)) {
                int level = (Integer)armorItem.getAllEnchantments(stack).get(Enchantments.f_44986_);
                damageDivider += damageDivider / 2 * level;
            }
        }
        return maxDamage / damageDivider;
    }

    public boolean m_6584_(int duration, int amplifier) {
        int j = 15 >> amplifier;
        if (j > 0) {
            return duration % j == 0;
        }
        return true;
    }
}

