/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.utility;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.grid.vampiresdelight.common.VDConfiguration;
import net.grid.vampiresdelight.common.utility.VDHelper;
import net.grid.vampiresdelight.common.utility.VDIntegrationUtils;
import net.grid.vampiresdelight.common.utility.VDTextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

@ParametersAreNonnullByDefault
public class VDTooltipUtils {
    public static void addSplitTooltip(String key, List<Component> tooltip, ChatFormatting style) {
        for (String part : VDTextUtils.getStraightTranslation(key).split("\n")) {
            tooltip.add((Component)Component.m_237113_((String)part).m_130940_(style));
        }
    }

    public static void addShiftTooltip(String key, List<Component> tooltip) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)VDTextUtils.getTranslation(key, new Object[0]).m_130940_(ChatFormatting.GRAY));
        } else {
            String[] mainTooltip = VDTextUtils.getStraightTranslation("tooltip.holdShiftForInfo").split("%s");
            MutableComponent resultTooltip = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)mainTooltip[0]).m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)Component.m_237113_((String)VDTextUtils.getStraightTranslation("tooltip.shift")).m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)mainTooltip[1]).m_130940_(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)resultTooltip);
        }
    }

    public static void addFactionFoodToolTips(List<Component> tooltip, Player player, IPlayableFaction<?> foodFaction) {
        if (!(VDHelper.isVampire((Player)player) || ((Boolean)VDConfiguration.HUNTER_TOOLTIPS_FOR_EVERYONE.get()).booleanValue() || Objects.equals(foodFaction, VReference.VAMPIRE_FACTION))) {
            return;
        }
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"text.vampirism.faction_specifics").m_130940_(ChatFormatting.GRAY));
        ChatFormatting color = Objects.equals(foodFaction, VReference.VAMPIRE_FACTION) ? (VDHelper.isVampire((Player)player) ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED) : (!VDHelper.isVampire((Player)player) ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED);
        tooltip.add((Component)Component.m_237113_((String)" ").m_7220_(foodFaction.getName()).m_130940_(color));
    }

    public static void addWerewolfFactionFoodToolTips(List<Component> tooltip, Player player) {
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"text.vampirism.faction_specifics").m_130940_(ChatFormatting.GRAY));
        ChatFormatting color = VDIntegrationUtils.isWerewolf(player) ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED;
        tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"text.werewolves.werewolf")).m_130940_(color));
    }
}

