/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.overstressclutch;

import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.Lang;
import com.hlysine.create_connected.content.overstressclutch.OverstressClutchBlock;
import com.hlysine.create_connected.datagen.advancements.AdvancementBehaviour;
import com.hlysine.create_connected.datagen.advancements.CCAdvancements;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.content.redstone.diodes.BrassDiodeBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Components;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.TickPriority;

public class OverstressClutchBlockEntity
extends SplitShaftBlockEntity {
    public int delay;
    public ScrollValueBehaviour maxDelay;

    public OverstressClutchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        AdvancementBehaviour.registerAwardables((SmartBlockEntity)this, behaviours, CCAdvancements.OVERSTRESS_CLUTCH);
        this.maxDelay = new TimeDelayScrollValueBehaviour((Component)Components.translatable((String)"create_connected.overstress_clutch.uncouple_delay"), (SmartBlockEntity)this, (ValueBoxTransform)new CenteredSideValueBoxTransform((state, d) -> {
            Direction.Axis axis = d.m_122434_();
            Direction.Axis bearingAxis = (Direction.Axis)state.m_61143_((Property)OverstressClutchBlock.AXIS);
            return bearingAxis != axis;
        })).between(1, 72000);
        this.maxDelay.withFormatter(this::format);
        this.maxDelay.withCallback(this::onMaxDelayChanged);
        this.maxDelay.setValue(1);
        behaviours.add((BlockEntityBehaviour)this.maxDelay);
    }

    private void onMaxDelayChanged(int newMax) {
        this.delay = Mth.m_14045_((int)this.delay, (int)0, (int)newMax);
        this.sendData();
    }

    private String format(int value) {
        if (value < 60) {
            return value + "t";
        }
        if (value < 1200) {
            return value / 20 + "s";
        }
        return value / 20 / 60 + "m";
    }

    public boolean isIdle() {
        return this.delay == 0;
    }

    public void initialize() {
        this.onKineticUpdate();
        super.initialize();
    }

    public void onKineticUpdate() {
        if (this.m_58900_().m_61143_(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLED && ((Boolean)this.m_58900_().m_61143_((Property)OverstressClutchBlock.POWERED)).booleanValue()) {
            this.resetClutch();
            return;
        }
        if (IRotate.StressImpact.isEnabled() && !((Boolean)this.m_58900_().m_61143_((Property)OverstressClutchBlock.POWERED)).booleanValue() && this.isOverStressed() && this.m_58900_().m_61143_(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.COUPLED && this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(OverstressClutchBlock.STATE, (Comparable)((Object)OverstressClutchBlock.ClutchState.UNCOUPLING)), 18);
            this.delay = this.maxDelay.getValue() - 1;
            this.sendData();
            return;
        }
        if (!this.isOverStressed() && this.m_58900_().m_61143_(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLING && this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(OverstressClutchBlock.STATE, (Comparable)((Object)OverstressClutchBlock.ClutchState.COUPLED)), 18);
        }
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.onKineticUpdate();
    }

    public float getRotationSpeedModifier(Direction face) {
        if (this.hasSource() && face != this.getSourceFacing() && this.m_58900_().m_61143_(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLED) {
            return 0.0f;
        }
        return 1.0f;
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToTooltip(tooltip, isPlayerSneaking);
        if (this.m_58900_().m_61143_(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLED) {
            Lang.translate("gui.overstress_clutch.uncoupled", new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
            MutableComponent hint = Lang.translateDirect("gui.overstress_clutch.uncoupled_explanation", new Object[0]);
            List cutString = TooltipHelper.cutTextComponent((Component)hint, (TooltipHelper.Palette)TooltipHelper.Palette.GRAY_AND_WHITE);
            for (Component component : cutString) {
                Lang.builder().add(component.m_6881_()).forGoggles(tooltip);
            }
            added = true;
        }
        return added;
    }

    public void resetClutch() {
        if (this.m_58900_().m_61143_(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLED && !this.isOverStressed()) {
            assert (this.f_58857_ != null);
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(OverstressClutchBlock.STATE, (Comparable)((Object)OverstressClutchBlock.ClutchState.COUPLED)), 3);
            RotationPropagator.handleRemoved((Level)this.f_58857_, (BlockPos)this.m_58899_(), (KineticBlockEntity)this);
            RotationPropagator.handleAdded((Level)this.f_58857_, (BlockPos)this.m_58899_(), (KineticBlockEntity)this);
        }
    }

    public void tick() {
        super.tick();
        if (this.m_58900_().m_61143_(OverstressClutchBlock.STATE) == OverstressClutchBlock.ClutchState.UNCOUPLING && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_186464_(this.m_58899_(), (Block)CCBlocks.OVERSTRESS_CLUTCH.get(), 0, TickPriority.EXTREMELY_HIGH);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.delay = compound.m_128451_("Delay");
        super.read(compound, clientPacket);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Delay", this.delay);
        super.write(compound, clientPacket);
    }

    public static class TimeDelayScrollValueBehaviour
    extends ScrollValueBehaviour {
        public TimeDelayScrollValueBehaviour(Component label, SmartBlockEntity be, ValueBoxTransform slot) {
            super(label, be, slot);
        }

        public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
            return new ValueSettingsBoard(this.label, 60, 10, com.simibubi.create.foundation.utility.Lang.translatedOptions((String)"generic.unit", (String[])new String[]{"ticks", "seconds", "minutes"}), new ValueSettingsFormatter(this::formatSettings));
        }

        public void onShortInteract(Player player, InteractionHand hand, Direction side) {
            BlockState blockState = this.blockEntity.m_58900_();
            Block block = blockState.m_60734_();
            if (block instanceof BrassDiodeBlock) {
                BrassDiodeBlock bdb = (BrassDiodeBlock)block;
                bdb.toggle(this.getWorld(), this.getPos(), blockState, player, hand);
            }
        }

        public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlHeld) {
            int multiplier;
            int value = valueSetting.value();
            switch (valueSetting.row()) {
                case 0: {
                    int n = 1;
                    break;
                }
                case 1: {
                    int n = 20;
                    break;
                }
                default: {
                    int n = multiplier = 1200;
                }
            }
            if (!valueSetting.equals((Object)this.getValueSettings())) {
                this.playFeedbackSound((BlockEntityBehaviour)this);
            }
            this.setValue(Math.max(1, Math.max(1, value) * multiplier));
        }

        public ValueSettingsBehaviour.ValueSettings getValueSettings() {
            int row = 0;
            int value = this.value;
            if (value > 1200) {
                value /= 1200;
                row = 2;
            } else if (value > 60) {
                value /= 20;
                row = 1;
            }
            return new ValueSettingsBehaviour.ValueSettings(row, value);
        }

        public MutableComponent formatSettings(ValueSettingsBehaviour.ValueSettings settings) {
            int value = Math.max(1, settings.value());
            return Components.literal((String)(switch (settings.row()) {
                case 0 -> value + "t";
                case 1 -> "0:" + (value < 10 ? "0" : "") + value;
                default -> value + ":00";
            }));
        }

        public String getClipboardKey() {
            return "Timings";
        }
    }
}

