/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.config.PlayerConfig;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class FaceSlotBlock
extends HorizontalDirectionalBlock
implements INetworked,
EntityBlock {
    private long ignoreEventTime;
    private long ignoreEventThresh = 2L;

    protected FaceSlotBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult rightAction(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        Optional<InteractionResult> useResult;
        boolean altAction;
        int slot = this.getFaceSlot(state, hit);
        InteractContext context = new InteractContext(state, level, pos, player, hit, slot);
        boolean bl = altAction = PlayerConfig.getInvertShift(player) != player.m_6144_();
        if (!PlayerConfig.getInvertClick(player) && (useResult = this.useSlotInvertible(context)).isPresent()) {
            return useResult.get();
        }
        useResult = this.useSlot(context);
        if (useResult.isPresent()) {
            return useResult.get();
        }
        if (slot < 0) {
            return InteractionResult.PASS;
        }
        if (PlayerConfig.getInvertClick(player)) {
            return this.takeSlot(context, altAction);
        }
        return this.putSlot(context, altAction);
    }

    public InteractionResult leftAction(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        Optional<InteractionResult> useResult;
        boolean altAction;
        int slot = this.getFaceSlot(state, hit);
        InteractContext context = new InteractContext(state, level, pos, player, hit, slot);
        boolean bl = altAction = PlayerConfig.getInvertShift(player) != player.m_6144_();
        if (PlayerConfig.getInvertClick(player) && (useResult = this.useSlotInvertible(context)).isPresent()) {
            return useResult.get();
        }
        if (slot < 0) {
            return InteractionResult.PASS;
        }
        if (PlayerConfig.getInvertClick(player)) {
            return this.putSlot(context, altAction);
        }
        return this.takeSlot(context, altAction);
    }

    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        return this.rightAction(state, level, pos, player, hit);
    }

    public void m_6256_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player) {
        BlockHitResult hit = WorldUtils.rayTraceEyes(level, player, pos);
        if (hit.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        if (!hit.m_82425_().equals((Object)pos)) {
            return;
        }
        this.leftAction(state, level, pos, player, hit);
    }

    public Optional<InteractionResult> useSlot(InteractContext context) {
        return Optional.of(InteractionResult.PASS);
    }

    public Optional<InteractionResult> useSlotInvertible(InteractContext context) {
        return Optional.of(InteractionResult.PASS);
    }

    public InteractionResult putSlot(InteractContext context, boolean altAction) {
        return InteractionResult.PASS;
    }

    public InteractionResult takeSlot(InteractContext context, boolean altAction) {
        return InteractionResult.PASS;
    }

    public final int getFaceSlot(@NotNull BlockState state, @NotNull BlockHitResult hit) {
        Direction side = hit.m_82434_();
        if (state.m_61143_((Property)f_54117_) != side) {
            return -1;
        }
        return this.getFaceSlot(hit.m_82434_(), FaceSlotBlock.normalizeHitVec(hit.m_82450_()));
    }

    @NotNull
    private static Vec3 normalizeHitVec(@NotNull Vec3 hit) {
        return new Vec3((hit.f_82479_ < 0.0 ? hit.f_82479_ - Math.floor(hit.f_82479_) : hit.f_82479_) % 1.0, (hit.f_82480_ < 0.0 ? hit.f_82480_ - Math.floor(hit.f_82480_) : hit.f_82480_) % 1.0, (hit.f_82481_ < 0.0 ? hit.f_82481_ - Math.floor(hit.f_82481_) : hit.f_82481_) % 1.0);
    }

    protected int getFaceSlot(Direction correctSide, @NotNull Vec3 normalizedHit) {
        return -1;
    }

    protected boolean hitWithinArea(Direction side, Vec3 normalizedHit, float min, float max) {
        return this.hitWithinX(side, normalizedHit, min, max) && this.hitWithinY(normalizedHit, min, max);
    }

    protected boolean hitWithinY(@NotNull Vec3 normalizedHit, float min, float max) {
        return normalizedHit.f_82480_ > (double)min && normalizedHit.f_82480_ < (double)max;
    }

    protected boolean hitWithinX(Direction side, @NotNull Vec3 normalizedHit, float min, float max) {
        return switch (side) {
            case Direction.NORTH -> {
                if (normalizedHit.f_82479_ > (double)(1.0f - max) && normalizedHit.f_82479_ < (double)(1.0f - min)) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (normalizedHit.f_82479_ > (double)min && normalizedHit.f_82479_ < (double)max) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (normalizedHit.f_82481_ > (double)min && normalizedHit.f_82481_ < (double)max) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (normalizedHit.f_82481_ > (double)(1.0f - max) && normalizedHit.f_82481_ < (double)(1.0f - min)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public static class InteractContext {
        public BlockState state;
        public Level level;
        public BlockPos pos;
        public Player player;
        public BlockHitResult hit;
        public int slot;

        public InteractContext(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit, int slot) {
            this.state = state;
            this.level = level;
            this.pos = pos;
            this.player = player;
            this.hit = hit;
            this.slot = slot;
        }

        public <BE extends BlockEntity> BE getCheckedEntity(Class<BE> type) {
            if (this.level.m_8055_(this.pos) != this.state) {
                return null;
            }
            return WorldUtils.getBlockEntity((BlockGetter)this.level, this.pos, type);
        }

        public <BE extends BlockEntity, B extends Block> BE getCheckedEntity(Class<BE> type, Class<B> blockType) {
            if (!blockType.isInstance(this.state.m_60734_())) {
                return null;
            }
            return this.getCheckedEntity(type);
        }
    }
}

