/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.BracketDumper;
import com.blamejared.crafttweaker.api.annotation.BracketResolver;
import com.blamejared.crafttweaker.api.annotation.BracketValidator;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.BracketValidators;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/vampirism/BracketHandlers")
@ZenCodeType.Name(value="mods.vampirism.BracketHandlers")
public class SkillBracket {
    @ZenCodeType.Method
    @BracketValidator(value="skill")
    public static boolean validateSkill(String tokens) {
        if (ResourceLocation.m_135820_((String)tokens) == null) {
            CommonLoggers.zenCode().error("Invalid Bracket Syntax: <skill:" + tokens + ">! Syntax is <skill:modid:skill_id>");
            return false;
        }
        return BracketValidators.validateBracket((String)"skill", (String)tokens, SkillBracket::getSkill);
    }

    @ZenCodeType.Method
    @BracketResolver(value="skill")
    public static ISkill<?> getSkill(String tokens) {
        int length = tokens.split(":").length;
        if (length != 2) {
            throw new IllegalArgumentException("Could not get skill <skill:" + tokens + ">");
        }
        ResourceLocation resourceLocation = new ResourceLocation(tokens);
        ISkill skill = (ISkill)((IForgeRegistry)ModRegistries.SKILLS.get()).getValue(resourceLocation);
        if (skill == null) {
            throw new IllegalArgumentException("Could not get skill <skill:" + tokens + ">");
        }
        return skill;
    }

    public static String getCommandString(ISkill<?> skill) {
        return "<skill:" + ((IForgeRegistry)ModRegistries.SKILLS.get()).getKey(skill) + ">";
    }

    @ZenCodeType.Method
    @BracketDumper(value="skill")
    public static Collection<String> getSkillDump() {
        return ((IForgeRegistry)ModRegistries.SKILLS.get()).getValues().stream().map(SkillBracket::getCommandString).collect(Collectors.toList());
    }
}

