/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.mca;

import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.api.entity.convertible.ICurableConvertedCreature;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModVillage;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.villager.Trades;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism_integrations.mca.MCACompat;
import de.teamlapen.vampirism_integrations.mca.MCARegistration;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.brain.VillagerTasksMCA;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.Gender;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ConvertedVillagerEntityMCA
extends VillagerEntityMCA
implements ICurableConvertedCreature<VillagerEntityMCA> {
    public static final List<SensorType<? extends Sensor<? super Villager>>> SENSOR_TYPES;
    private static final byte EVENT_ID_CURE = 40;
    private static final EntityDataAccessor<Boolean> CONVERTING;
    private EnumStrength garlicCache = EnumStrength.NONE;
    private boolean sundamageCache;
    private int bloodTimer = 0;
    private int conversionTime;
    private UUID conversationStarter;

    public ConvertedVillagerEntityMCA(EntityType<ConvertedVillagerEntityMCA> type, Level w, Gender gender) {
        super(type, w, gender);
    }

    public void m_8107_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.isConverting((PathfinderMob)this)) {
            --this.conversionTime;
            if (this.conversionTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20492_, timer -> {
                this.conversionTime = timer;
            })) {
                this.cureEntity((ServerLevel)this.m_9236_(), (PathfinderMob)this, (EntityType<VillagerEntityMCA>)((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.getGenetics().getGender() == Gender.FEMALE ? MCACompat.FEMALE_VILLAGER : MCACompat.MALE_VILLAGER)));
            }
        }
        if (this.f_19797_ % 40 == 1) {
            this.isGettingGarlicDamage((LevelAccessor)this.m_9236_(), true);
        }
        if (this.f_19797_ % 8 == 2) {
            this.isGettingSundamage((LevelAccessor)this.m_9236_(), true);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isGettingSundamage((LevelAccessor)this.m_9236_()) && this.f_19797_ % 40 == 11) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 42));
            }
            if (this.isGettingGarlicDamage((LevelAccessor)this.m_9236_()) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient((IVampire)this, (EnumStrength)this.isGettingGarlicDamage((LevelAccessor)this.m_9236_()), (int)this.f_19797_);
            }
        }
        ++this.bloodTimer;
        super.m_8107_();
    }

    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    public VillagerEntityMCA createCuredEntity(@NotNull PathfinderMob entity, @NotNull EntityType<VillagerEntityMCA> newType) {
        VillagerEntityMCA villager = (VillagerEntityMCA)newType.m_20615_(entity.m_9236_());
        assert (villager != null);
        villager.m_20361_((Entity)entity);
        villager.f_20883_ = entity.f_20883_;
        villager.f_20885_ = entity.f_20885_;
        return villager;
    }

    public VillagerEntityMCA cureEntity(ServerLevel world, PathfinderMob entity, EntityType<VillagerEntityMCA> newType) {
        Player playerentity;
        VillagerEntityMCA villager = (VillagerEntityMCA)super.cureEntity(world, entity, newType);
        if (this.conversationStarter != null && (playerentity = world.m_46003_(this.conversationStarter)) instanceof ServerPlayer) {
            ModAdvancements.TRIGGER_CURED_VAMPIRE_VILLAGER.trigger((ServerPlayer)playerentity, (Entity)this, (Villager)villager);
            world.m_8670_(ReputationEventType.f_26985_, (Entity)playerentity, (ReputationEventHandler)villager);
        }
        return villager;
    }

    public boolean m_7327_(@Nonnull Entity entity) {
        if (!this.m_9236_().f_46443_ && this.wantsBlood() && entity instanceof Player && !Helper.isHunter((Entity)entity) && !UtilLib.canReallySee((LivingEntity)((LivingEntity)entity), (LivingEntity)this, (boolean)true)) {
            int amt = VampirePlayer.getOpt((Player)((Player)entity)).map(vampire -> vampire.onBite((IVampire)this)).orElse(0);
            this.drinkBlood(amt, 0.7f);
            return true;
        }
        return super.m_7327_(entity);
    }

    public EntityDataAccessor<Boolean> getConvertingDataParam() {
        return CONVERTING;
    }

    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, amt * 20));
        this.bloodTimer = -1200 - this.f_19796_.m_188503_(1200);
    }

    public LivingEntity getRepresentingEntity() {
        return this;
    }

    protected Component m_5677_() {
        ResourceLocation profName = ForgeRegistries.VILLAGER_PROFESSIONS.getKey((Object)this.m_7141_().m_35571_());
        String var10002 = EntityType.f_20492_.m_20675_();
        return Component.m_237115_((String)(var10002 + "." + (String)(!"minecraft".equals(profName.m_135827_()) ? profName.m_135827_() + "." : "") + profName.m_135815_()));
    }

    public void m_7822_(byte id) {
        if (id == 16) {
            super.m_7822_(id);
            return;
        }
        if (id == 40) {
            id = (byte)16;
        }
        if (!this.handleSound(id, (PathfinderMob)this)) {
            super.m_7822_(id);
        }
    }

    @Nonnull
    public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, (LevelAccessor)iWorld);
        }
        return this.garlicCache;
    }

    public boolean isGettingSundamage(LevelAccessor iWorld, boolean forceRefresh) {
        return !forceRefresh ? this.sundamageCache : (this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, (LevelAccessor)iWorld, (ProfilerFiller)this.m_9236_().m_46473_()));
    }

    public boolean isIgnoringSundamage() {
        return false;
    }

    @Nonnull
    public InteractionResult m_6071_(Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return stack.m_41720_() != Items.f_42436_ ? super.m_6071_(player, hand) : this.interactWithCureItem(player, stack, (PathfinderMob)this);
    }

    public ItemStack m_5584_(Level world, ItemStack stack) {
        if (stack.m_41720_() == Items.f_42436_ && !this.isConverting((PathfinderMob)this) && this.m_21023_(MobEffects.f_19613_)) {
            this.startConverting(this.getInteractions().getInteractingPlayer().map(Entity::m_20148_).orElse(null), this.m_217043_().m_188503_(2400) + 2400, (PathfinderMob)this);
        }
        return super.m_5584_(world, stack);
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("ConversionTime", 99) && compound.m_128451_("ConversionTime") > -1) {
            this.startConverting(compound.m_128403_("ConversionPlayer") ? compound.m_128342_("ConversionPlayer") : null, compound.m_128451_("ConversionTime"), (PathfinderMob)this);
        }
    }

    public void startConverting(@Nullable UUID conversionStarterIn, int conversionTimeIn, @Nonnull PathfinderMob entity) {
        super.startConverting(conversionStarterIn, conversionTimeIn, entity);
        entity.m_9236_().m_7605_((Entity)entity, (byte)40);
        this.conversationStarter = conversionStarterIn;
        this.conversionTime = conversionTimeIn;
    }

    public void m_35424_(@Nonnull Brain<VillagerEntityMCA> brain) {
        VillagerTasksMCA.initializeTasks((VillagerEntityMCA)this, brain);
        AgeState age = AgeState.byCurrentAge((int)this.m_146764_());
        if (age != AgeState.ADULT) {
            brain.m_21912_((Schedule)ModVillage.CONVERTED_DEFAULT.get());
            brain.m_21862_(this.m_9236_().m_46468_(), this.m_9236_().m_46467_() + 21L);
        }
    }

    public boolean wantsBlood() {
        return this.bloodTimer > 0;
    }

    public boolean useBlood(int amt, boolean allowPartial) {
        this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, amt * 20));
        this.bloodTimer = 0;
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.registerConvertingData((PathfinderMob)this);
    }

    @Nonnull
    protected Brain<?> m_8075_(@Nonnull Dynamic<?> dynamicIn) {
        Brain brain = VillagerTasksMCA.createProfile().m_22073_(dynamicIn);
        this.m_35424_((Brain<VillagerEntityMCA>)brain);
        return brain;
    }

    public void m_35483_(ServerLevel world) {
        Brain brain = this.getMCABrain();
        brain.m_21933_(world, (LivingEntity)this);
        this.f_20939_ = brain.m_21973_();
        this.m_35424_((Brain<VillagerEntityMCA>)this.getMCABrain());
    }

    protected void m_7604_() {
        super.m_7604_();
        if (!this.m_6616_().isEmpty() && this.m_217043_().m_188503_(3) == 0) {
            this.m_35277_(this.m_6616_(), Trades.converted_trades, 1);
        }
    }

    static {
        CONVERTING = SynchedEntityData.m_135353_(ConvertedVillagerEntityMCA.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SENSOR_TYPES = Lists.newArrayList((Iterable)Villager.f_35368_);
        SENSOR_TYPES.remove(SensorType.f_26815_);
        SENSOR_TYPES.add((SensorType<? extends Sensor<? super Villager>>)((SensorType)ModVillage.VAMPIRE_VILLAGER_HOSTILES.get()));
    }

    public static class ConvertingHandler
    implements IConvertingHandler<VillagerEntityMCA> {
        public IConvertedCreature<VillagerEntityMCA> createFrom(VillagerEntityMCA entity) {
            Villager converted = (Villager)((EntityType)(entity.getGenetics().getGender() == Gender.FEMALE ? MCARegistration.FEMALE_CONVERTED_VILLAGER : MCARegistration.MALE_CONVERTED_VILLAGER).get()).m_20615_(entity.m_9236_());
            CompoundTag nbtExtended = new CompoundTag();
            ExtendedCreature.getSafe((Entity)converted).ifPresent(ec -> ec.saveData(nbtExtended));
            converted.m_20361_((Entity)entity);
            ExtendedCreature.getSafe((Entity)converted).ifPresent(ec -> ec.loadData(nbtExtended));
            if (ModList.get().getModContainerById("vampirism").map(ModContainer::getModInfo).map(IModInfo::getVersion).map(version -> version.getMinorVersion() <= 9 && version.getIncrementalVersion() <= 3).orElse(true).booleanValue()) {
                entity.m_146870_();
            }
            converted.f_20883_ = entity.f_20883_;
            converted.f_20885_ = entity.f_20885_;
            return (IConvertedCreature)converted;
        }
    }
}

