/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.mca;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism_integrations.mca.AggressiveVillagerEntityMCA;
import de.teamlapen.vampirism_integrations.mca.ConvertedVillagerEntityMCA;
import de.teamlapen.vampirism_integrations.mca.MCACompat;
import de.teamlapen.vampirism_integrations.mca.MCAEntityClassRedirect;
import de.teamlapen.vampirism_integrations.mca.client.ClientProxy;
import forge.net.mca.entity.VillagerEntityMCA;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class MCARegistration {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"vampirism_integrations");
    public static final RegistryObject<EntityType<ConvertedVillagerEntityMCA>> MALE_CONVERTED_VILLAGER = MCARegistration.prepareEntityType("male_villager_mca_converted", MCARegistration.getBuilder(MCAEntityClassRedirect::createConverted, true), true);
    public static final RegistryObject<EntityType<ConvertedVillagerEntityMCA>> FEMALE_CONVERTED_VILLAGER = MCARegistration.prepareEntityType("female_villager_mca_converted", MCARegistration.getBuilder(MCAEntityClassRedirect::createConverted, false), false);
    public static final RegistryObject<EntityType<AggressiveVillagerEntityMCA>> MALE_AGGRESSIVE_VILLAGER = MCARegistration.prepareEntityType("male_villager_mca_angry", MCARegistration.getBuilder(MCAEntityClassRedirect::createAngry, true), true);
    public static final RegistryObject<EntityType<AggressiveVillagerEntityMCA>> FEMALE_AGGRESSIVE_VILLAGER = MCARegistration.prepareEntityType("female_villager_mca_angry", MCARegistration.getBuilder(MCAEntityClassRedirect::createAngry, false), true);

    static void registerEntities(IEventBus bus) {
        ENTITY_TYPES.register(bus);
        bus.addListener(MCARegistration::onRegisterEntityTypeAttributes);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(ClientProxy::onRegisterRenderer));
    }

    private static <T extends Villager> Supplier<EntityType.Builder<T>> getBuilder(Function<Boolean, EntityType.Builder<T>> supplier, boolean male) {
        return () -> {
            if (ModList.get().isLoaded("mca")) {
                return (EntityType.Builder)supplier.apply(male);
            }
            return null;
        };
    }

    private static <T extends Villager> RegistryObject<EntityType<T>> prepareEntityType(String id, @Nullable Supplier<EntityType.Builder<T>> builder, boolean spawnable) {
        if (ModList.get().isLoaded("mca") && builder != null) {
            return ENTITY_TYPES.register(id, () -> {
                EntityType.Builder type = ((EntityType.Builder)builder.get()).setTrackingRange(80).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true);
                if (!spawnable) {
                    type.m_20698_();
                }
                return type.m_20712_("vampirism_integrations:" + id);
            });
        }
        return RegistryObject.createOptional((ResourceLocation)new ResourceLocation("vampirism_integrations", id), (ResourceLocation)ForgeRegistries.ENTITY_TYPES.getRegistryName(), (String)"vampirism_integrations");
    }

    static void registerConvertibles() {
        ResourceLocation overlay = new ResourceLocation("vampirism_integrations", "mca/overlay.png");
        ConvertedVillagerEntityMCA.ConvertingHandler c = new ConvertedVillagerEntityMCA.ConvertingHandler();
        VampirismAPI.entityRegistry().addConvertible((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(MCACompat.MALE_VILLAGER), overlay, (IConvertingHandler)c);
        VampirismAPI.entityRegistry().addConvertible((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(MCACompat.FEMALE_VILLAGER), overlay, (IConvertingHandler)c);
    }

    static void onRegisterEntityTypeAttributes(EntityAttributeCreationEvent event) {
        MALE_AGGRESSIVE_VILLAGER.ifPresent(entry -> event.put(entry, VillagerEntityMCA.createVillagerAttributes().m_22265_()));
        FEMALE_AGGRESSIVE_VILLAGER.ifPresent(entry -> event.put(entry, VillagerEntityMCA.createVillagerAttributes().m_22265_()));
        MALE_CONVERTED_VILLAGER.ifPresent(entry -> event.put(entry, VillagerEntityMCA.createVillagerAttributes().m_22265_()));
        FEMALE_CONVERTED_VILLAGER.ifPresent(entry -> event.put(entry, VillagerEntityMCA.createVillagerAttributes().m_22265_()));
    }
}

