/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.block;

import java.util.List;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidMobEffect;

public record MobEffectCloudFluidEffect(List<FluidMobEffect> effects) implements FluidEffect<FluidEffectContext.Block>
{
    public static final RecordLoadable<MobEffectCloudFluidEffect> LOADER = RecordLoadable.create((RecordField)FluidMobEffect.LOADABLE.list(1).requiredField("effects", e -> e.effects), MobEffectCloudFluidEffect::new);

    @Override
    public RecordLoadable<MobEffectCloudFluidEffect> getLoader() {
        return LOADER;
    }

    public static AreaEffectCloud makeCloud(FluidEffectContext.Block context) {
        Vec3 location = context.getHitResult().m_82450_();
        AreaEffectCloud cloud = new AreaEffectCloud(context.getLevel(), location.m_7096_(), location.m_7098_(), location.m_7094_());
        cloud.m_19718_(context.getEntity());
        cloud.m_19712_(1.0f);
        cloud.m_19732_(-0.5f);
        cloud.m_19740_(10);
        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
        return cloud;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Block context, IFluidHandler.FluidAction action) {
        if (context.isOffsetReplaceable()) {
            float scale = level.value();
            if (action.execute()) {
                AreaEffectCloud cloud = MobEffectCloudFluidEffect.makeCloud(context);
                boolean hasEffects = false;
                for (FluidMobEffect effect : this.effects) {
                    int time = (int)((float)effect.time() * scale);
                    if (time <= 10) continue;
                    cloud.m_19716_(effect.effectWithTime(time));
                    hasEffects = true;
                }
                if (hasEffects) {
                    context.getLevel().m_7967_((Entity)cloud);
                } else {
                    cloud.m_146870_();
                    return 0.0f;
                }
            }
            return scale;
        }
        return 0.0f;
    }
}

