/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.data.predicate.entity.MobTypePredicate;
import slimeknights.mantle.recipe.data.FluidNameIngredient;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.common.TinkerDamageTypes;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.tinkering.AbstractFluidEffectProvider;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidMobEffect;
import slimeknights.tconstruct.library.modifiers.fluid.TimeAction;
import slimeknights.tconstruct.library.modifiers.fluid.block.PlaceBlockFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.block.PotionCloudFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.AddBreathFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.AwardStatFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.CureEffectsFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.DamageFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.FireFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.FreezeFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.PotionFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.RemoveEffectFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.RestoreHungerFluidEffect;
import slimeknights.tconstruct.library.recipe.TagPredicate;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.traits.skull.StrongBonesModifier;

public class FluidEffectProvider
extends AbstractFluidEffectProvider {
    public FluidEffectProvider(PackOutput packOutput) {
        super(packOutput, "tconstruct");
    }

    @Override
    protected void addFluids() {
        this.addFluid((Fluid)Fluids.f_76193_, 50).addEntityEffect((IJsonPredicate<LivingEntity>)LivingEntityPredicate.WATER_SENSITIVE, new DamageFluidEffect(2.0f, TinkerDamageTypes.WATER)).addEntityEffect(FluidEffect.EXTINGUISH_FIRE);
        this.addFluid((Fluid)Fluids.f_76195_, 50).addEntityEffect((IJsonPredicate<LivingEntity>)LivingEntityPredicate.FIRE_IMMUNE.inverted(), new DamageFluidEffect(2.0f, TinkerDamageTypes.FLUID_FIRE)).addEntityEffect(new FireFluidEffect(TimeAction.SET, 10)).addBlockEffect(new PlaceBlockFluidEffect(Blocks.f_50083_));
        this.addFluid((TagKey<Fluid>)Tags.Fluids.MILK, 100).addEntityEffect(new CureEffectsFluidEffect((ItemLike)Items.f_42455_)).addEntityEffect(StrongBonesModifier.FLUID_EFFECT);
        this.addFluid((TagKey<Fluid>)Objects.requireNonNull(TinkerFluids.powderedSnow.getCommonTag()), 100).addEntityEffect(new FreezeFluidEffect(TimeAction.ADD, 160)).addBlockEffect(new PlaceBlockFluidEffect(Blocks.f_50125_));
        this.burningFluid("blazing_blood", (TagKey<Fluid>)TinkerFluids.blazingBlood.getTag(), 50, 3.0f, 5);
        int slimeballPiece = 50;
        this.addFluid((TagKey<Fluid>)TinkerFluids.earthSlime.getTag(), slimeballPiece).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19621_, 300).effect(MobEffects.f_19597_, 300));
        this.addFluid((TagKey<Fluid>)TinkerFluids.skySlime.getTag(), slimeballPiece).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19603_, 400).effect(MobEffects.f_19597_, 300));
        this.addFluid((TagKey<Fluid>)TinkerFluids.enderSlime.getTag(), slimeballPiece).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19620_, 100).effect(MobEffects.f_19597_, 300));
        this.addFluid((TagKey<Fluid>)TinkerFluids.venom.getTag(), slimeballPiece).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19614_, 100).effect(MobEffects.f_19600_, 200));
        this.addFluid((TagKey<Fluid>)TinkerFluids.magma.getTag(), slimeballPiece).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19607_, 500));
        this.addFluid((TagKey<Fluid>)TinkerFluids.liquidSoul.getTag(), 50).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19597_, 500, 2).effect(MobEffects.f_19610_, 100));
        this.addFluid((TagKey<Fluid>)TinkerFluids.moltenEnder.getTag(), 50).addEntityEffect(new DamageFluidEffect(1.0f, TinkerDamageTypes.FLUID_MAGIC)).addEntityEffect(FluidEffect.TELEPORT);
        this.addFluid((TagKey<Fluid>)TinkerFluids.honey.getTag(), slimeballPiece).addEntityEffect(new RestoreHungerFluidEffect(1, 0.12f, false, ItemOutput.fromItem((ItemLike)Items.f_42787_))).addEntityEffect(new RemoveEffectFluidEffect(MobEffects.f_19614_));
        int bowlSip = 50;
        this.addFluid((TagKey<Fluid>)TinkerFluids.beetrootSoup.getTag(), bowlSip).addEntityEffect(new RestoreHungerFluidEffect(1, 0.72f, false, ItemOutput.fromItem((ItemLike)Items.f_42734_)));
        this.addFluid((TagKey<Fluid>)TinkerFluids.mushroomStew.getTag(), bowlSip).addEntityEffect(new RestoreHungerFluidEffect(1, 0.72f, false, ItemOutput.fromItem((ItemLike)Items.f_42400_)));
        this.addFluid((TagKey<Fluid>)TinkerFluids.rabbitStew.getTag(), bowlSip).addEntityEffect(new RestoreHungerFluidEffect(2, 0.6f, false, ItemOutput.fromItem((ItemLike)Items.f_42699_)));
        this.addFluid((TagKey<Fluid>)TinkerFluids.meatSoup.getTag(), bowlSip).addEntityEffect(new RestoreHungerFluidEffect(2, 0.48f, false, ItemOutput.fromItem(TinkerFluids.meatSoupBowl)));
        this.addFluid((TagKey<Fluid>)TinkerFluids.moltenPigIron.getTag(), 10).addEntityEffect(new RestoreHungerFluidEffect(2, 0.7f, false, ItemOutput.fromItem(TinkerCommons.bacon))).addEntityEffect(new FireFluidEffect(TimeAction.SET, 2));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenIron.getTag(), 2.0f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect((MobEffect)TinkerModifiers.magneticEffect.get(), 80, 2));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenSteel.getTag(), 2.0f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect((MobEffect)TinkerModifiers.repulsiveEffect.get(), 80, 2));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenCopper.getTag(), 1.5f).addEntityEffect(new AddBreathFluidEffect(80));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenBronze.getTag(), 2.0f).addEntityEffect(new AwardStatFluidEffect(Stats.f_12992_, -2000));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenAmethystBronze.getTag(), 1.5f).addEntityEffect(new AwardStatFluidEffect(Stats.f_12992_, 2000));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenZinc.getTag(), 1.5f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19596_, 200));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenBrass.getTag(), 2.0f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19607_, 160));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenTin.getTag(), 1.5f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19611_, 160));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenPewter.getTag(), 2.0f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19600_, 140));
        this.addFluid((TagKey<Fluid>)TinkerFluids.moltenGold.getTag(), 10).addEntityEffect((IJsonPredicate<LivingEntity>)new MobTypePredicate(MobType.f_21641_), new DamageFluidEffect(2.0f, TinkerDamageTypes.FLUID_MAGIC)).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19605_, 120, 1));
        this.addFluid((TagKey<Fluid>)TinkerFluids.moltenElectrum.getTag(), 10).addEntityEffect((IJsonPredicate<LivingEntity>)new MobTypePredicate(MobType.f_21641_), new DamageFluidEffect(2.0f, TinkerDamageTypes.FLUID_MAGIC)).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19598_, 160, 1));
        this.addFluid((TagKey<Fluid>)TinkerFluids.moltenRoseGold.getTag(), 10).addEntityEffect((IJsonPredicate<LivingEntity>)new MobTypePredicate(MobType.f_21641_), new DamageFluidEffect(2.0f, TinkerDamageTypes.FLUID_MAGIC)).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19616_, 300, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenAluminum.getTag(), 1.0f).addEntityEffect(new CureEffectsFluidEffect((ItemLike)Items.f_42455_));
        this.addFluid((TagKey<Fluid>)TinkerFluids.moltenSilver.getTag(), 10).addEntityEffect((IJsonPredicate<LivingEntity>)new MobTypePredicate(MobType.f_21641_), new DamageFluidEffect(2.0f, TinkerDamageTypes.FLUID_MAGIC)).addEntityEffect(new RemoveEffectFluidEffect(MobEffects.f_19615_));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenLead.getTag(), 1.5f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19597_, 120, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenNickel.getTag(), 1.5f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19613_, 140, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenInvar.getTag(), 2.0f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19612_, 200, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenConstantan.getTag(), 2.0f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19612_, 200, 1));
        this.burningFluid((TagKey<Fluid>)TinkerFluids.moltenUranium.getTag(), 1.5f, 3).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19614_, 200, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenCobalt.getTag(), 1.0f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19598_, 140, 1).effect(MobEffects.f_19596_, 140, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenManyullyn.getTag(), 3.0f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19606_, 300, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenHepatizon.getTag(), 2.5f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19606_, 200, 1));
        this.burningFluid((TagKey<Fluid>)TinkerFluids.moltenNetherite.getTag(), 3.5f, 4).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19610_, 300, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenSlimesteel.getTag(), 1.0f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19591_, 100, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenQueensSlime.getTag(), 1.0f).addEffect(TimeAction.SET, FluidMobEffect.builder().effect(MobEffects.f_19620_, 100, 1));
        this.burningFluid("glass", TinkerTags.Fluids.GLASS_SPILLING, 100, 1.0f, 3);
        this.burningFluid("clay", TinkerTags.Fluids.CLAY_SPILLING, 50, 1.5f, 3);
        this.burningFluid("metal_cheap", TinkerTags.Fluids.CHEAP_METAL_SPILLING, 10, 1.5f, 7);
        this.burningFluid("metal_average", TinkerTags.Fluids.AVERAGE_METAL_SPILLING, 10, 2.0f, 7);
        this.burningFluid("metal_expensive", TinkerTags.Fluids.EXPENSIVE_METAL_SPILLING, 10, 3.0f, 7);
        int bottleSip = 50;
        this.addFluid("potion_fluid", (TagKey<Fluid>)Objects.requireNonNull(TinkerFluids.potion.getCommonTag()), bottleSip).addEntityEffect(new PotionFluidEffect(0.25f, TagPredicate.ANY)).addBlockEffect(new PotionCloudFluidEffect(0.25f, TagPredicate.ANY));
        Function<String, TagPredicate> createBottle = value -> {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("Bottle", value);
            return new TagPredicate(compound);
        };
        String create = "create";
        this.addFluid("potion_create", (FluidIngredient)FluidNameIngredient.of((ResourceLocation)new ResourceLocation(create, "potion"), (int)bottleSip)).addCondition((ICondition)new ModLoadedCondition(create)).addEntityEffect(new PotionFluidEffect(0.25f, createBottle.apply("REGULAR"))).addEntityEffect(new PotionFluidEffect(0.5f, createBottle.apply("SPLASH"))).addEntityEffect(new PotionFluidEffect(0.75f, createBottle.apply("LINGERING"))).addBlockEffect(new PotionCloudFluidEffect(0.25f, createBottle.apply("REGULAR"))).addBlockEffect(new PotionCloudFluidEffect(0.5f, createBottle.apply("SPLASH"))).addBlockEffect(new PotionCloudFluidEffect(0.75f, createBottle.apply("LINGERING")));
    }

    private AbstractFluidEffectProvider.Builder metalborn(TagKey<Fluid> tag, float damage) {
        return this.burningFluid(tag.f_203868_().m_135815_(), tag, 10, damage, 0);
    }

    public String m_6055_() {
        return "Tinkers' Construct Spilling Fluid Provider";
    }
}

