/*
 * Decompiled with CFR 0.152.
 */
package fuzs.magnumtorch.config;

import net.minecraft.core.BlockPos;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SpawnShapeType {
    ELLIPSOID{

        @Override
        public boolean isPositionContained(int posX, int posY, int posZ, int width, int height) {
            return (double)((float)(posX * posX + posZ * posZ) / (float)(width * width) + (float)(posY * posY) / (float)(height * height)) <= 1.0;
        }
    }
    ,
    CYLINDER{

        @Override
        public boolean isPositionContained(int posX, int posY, int posZ, int width, int height) {
            return posX * posX + posZ * posZ <= width * width && posY <= height;
        }
    }
    ,
    CUBOID{

        @Override
        public boolean isPositionContained(int posX, int posY, int posZ, int width, int height) {
            return posX <= width && posZ <= width && posY <= height;
        }
    };


    public boolean isPositionContained(BlockPos pos, BlockPos toCheck, int width, int height) {
        int posX = Math.abs(pos.m_123341_() - toCheck.m_123341_());
        int posY = Math.abs(pos.m_123342_() - toCheck.m_123342_());
        int posZ = Math.abs(pos.m_123343_() - toCheck.m_123343_());
        return this.isPositionContained(posX, posY, posZ, width, height);
    }

    public abstract boolean isPositionContained(int var1, int var2, int var3, int var4, int var5);
}

