/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.placers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.satisfy.bloomingnature.core.registry.ObjectRegistry;
import net.satisfy.bloomingnature.core.registry.PlacerTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class LarchFoliagePlacer
extends FoliagePlacer {
    public static final Codec<LarchFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> LarchFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).and((App)IntProvider.m_146545_((int)0, (int)24).fieldOf("trunk_height").forGetter(placer -> placer.trunkHeight)).apply((Applicative)instance, LarchFoliagePlacer::new));
    private final IntProvider trunkHeight;

    public LarchFoliagePlacer(IntProvider intProvider, IntProvider intProvider2, IntProvider trunkHeight) {
        super(intProvider, intProvider2);
        this.trunkHeight = trunkHeight;
    }

    @NotNull
    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)PlacerTypesRegistry.LARCH_FOLIAGE_PLACER.get();
    }

    public int m_214116_(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return Math.max(12, trunkHeight - this.trunkHeight.m_214085_(random));
    }

    protected void m_213633_(LevelSimulatedReader levelSimulatedReader, FoliagePlacer.FoliageSetter foliageSetter, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment treeNode, int foliageHeight, int radius, int offset) {
        int l;
        BlockPos blockPos = treeNode.m_161451_();
        BlockPos.MutableBlockPos mutable = blockPos.m_122032_();
        for (l = 0; l < trunkHeight; ++l) {
            BlockPos trunkPos = blockPos.m_6630_(l);
            foliageSetter.m_271838_(trunkPos, ((Block)ObjectRegistry.LARCH_LOG.get()).m_49966_());
        }
        for (l = offset; l >= -foliageHeight - 4; --l) {
            if (l >= offset - 2) {
                mutable.m_122154_((Vec3i)blockPos, 0, l, 0);
                LarchFoliagePlacer.m_272253_((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
                continue;
            }
            if (l < offset - foliageHeight - 4) continue;
            mutable.m_122154_((Vec3i)blockPos, 0, l, 0);
            if (random.m_188499_()) {
                LarchFoliagePlacer.m_272253_((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.m_5484_(Direction.NORTH, 1).m_5484_(Direction.EAST, 1));
            }
            if (random.m_188499_()) {
                LarchFoliagePlacer.m_272253_((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.m_5484_(Direction.NORTH, 1).m_5484_(Direction.WEST, 1));
            }
            if (random.m_188499_()) {
                LarchFoliagePlacer.m_272253_((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.m_5484_(Direction.SOUTH, 1).m_5484_(Direction.EAST, 1));
            }
            if (random.m_188499_()) {
                LarchFoliagePlacer.m_272253_((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable.m_5484_(Direction.SOUTH, 1).m_5484_(Direction.WEST, 1));
            }
            this.m_225628_(levelSimulatedReader, foliageSetter, random, config, blockPos, Math.max(1, radius - 1), l, treeNode.m_68590_());
        }
    }

    protected boolean m_214203_(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return dx == radius && dz == radius && radius > 0;
    }

    protected void m_225628_(LevelSimulatedReader levelSimulatedReader, FoliagePlacer.FoliageSetter foliageSetter, RandomSource random, TreeConfiguration config, BlockPos centerPos, int radius, int y, boolean giantTrunk) {
        int i = giantTrunk ? 1 : 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int j = -radius; j <= radius + i; ++j) {
            for (int k = -radius; k <= radius + i; ++k) {
                if (this.m_214202_(random, j, y, k, radius, giantTrunk)) continue;
                mutable.m_122154_((Vec3i)centerPos, j, y, k);
                LarchFoliagePlacer.m_272253_((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)mutable);
            }
        }
    }
}

