/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.patchouli.component;

import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.client.patchouli.component.RotatingItemListComponentBase;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import vazkii.patchouli.api.IVariable;

public class RotatingItemListComponent
extends RotatingItemListComponentBase {
    @SerializedName(value="recipe_name")
    public String recipeName;
    @SerializedName(value="recipe_type")
    public String recipeType;

    @Override
    protected List<Ingredient> makeIngredients() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return new ArrayList<Ingredient>();
        }
        if ("enchanting_apparatus".equals(this.recipeType)) {
            EnchantingApparatusRecipe recipe = world.m_7465_().m_44013_((RecipeType)RecipeRegistry.APPARATUS_TYPE.get()).stream().filter(f -> f.id.toString().equals(this.recipeName)).findFirst().orElse(null);
            Iterator<RecipeType<? extends IEnchantingRecipe>> iterator = ArsNouveauAPI.getInstance().getEnchantingRecipeTypes().iterator();
            while (iterator.hasNext()) {
                EnchantingApparatusRecipe enchantingApparatusRecipe;
                RecipeType<? extends IEnchantingRecipe> type;
                RecipeType<? extends IEnchantingRecipe> enchantingRecipeRecipeType = type = iterator.next();
                Recipe recipe1 = world.m_7465_().m_44013_(enchantingRecipeRecipeType).stream().filter(f -> f.m_6423_().toString().equals(this.recipeName)).findFirst().orElse(null);
                if (!(recipe1 instanceof EnchantingApparatusRecipe)) continue;
                recipe = enchantingApparatusRecipe = (EnchantingApparatusRecipe)recipe1;
                break;
            }
            return recipe == null ? ImmutableList.of() : recipe.pedestalItems;
        }
        if ("imbuement_chamber".equals(this.recipeType)) {
            ImbuementRecipe recipe = world.m_7465_().m_44013_((RecipeType)RecipeRegistry.IMBUEMENT_TYPE.get()).stream().filter(f -> f.id.toString().equals(this.recipeName)).findFirst().orElse(null);
            return recipe == null ? ImmutableList.of() : recipe.pedestalItems;
        }
        if ("glyph_recipe".equals(this.recipeType)) {
            GlyphRecipe recipe = world.m_7465_().m_44043_(new ResourceLocation(this.recipeName)).orElse(null);
            return recipe == null ? ImmutableList.of() : recipe.inputs;
        }
        throw new IllegalArgumentException("Type must be 'enchanting_apparatus', 'glyph_recipe', or 'imbuement_chamber'!");
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.recipeName = ((IVariable)lookup.apply(IVariable.wrap((String)this.recipeName))).asString();
        this.recipeType = ((IVariable)lookup.apply(IVariable.wrap((String)this.recipeType))).asString();
    }
}

