/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.camera.ICameraMountable;
import com.hollingsworth.arsnouveau.common.block.ScryerCrystal;
import com.hollingsworth.arsnouveau.common.block.tile.ScryerCrystalTile;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSetCameraView;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.network.PacketDistributor;

public class ScryerCamera
extends Entity {
    public final double cameraSpeed;
    public int screenshotSoundCooldown = 0;
    protected int redstoneCooldown = 0;
    protected int toggleNightVisionCooldown = 0;
    private boolean shouldProvideNightVision = false;
    public float zoomAmount = 1.0f;
    public boolean zooming = false;
    private int viewDistance = -1;
    private boolean loadedChunks = false;

    public ScryerCamera(EntityType<ScryerCamera> type, Level level) {
        super(type, level);
        this.cameraSpeed = 3.3;
        this.f_19794_ = true;
    }

    public ScryerCamera(Level level, BlockPos pos) {
        this((EntityType<ScryerCamera>)((EntityType)ModEntities.SCRYER_CAMERA.get()), level);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ScryerCrystalTile) {
            ScryerCrystalTile cam = (ScryerCrystalTile)blockEntity;
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            if (cam.down) {
                y += 0.25;
            }
            this.m_6034_(x, y, z);
            this.setInitialPitchYaw();
        } else {
            this.m_146870_();
        }
    }

    public ScryerCamera(Level level, BlockPos pos, ScryerCamera oldCamera) {
        this(level, pos);
        oldCamera.discardCamera();
    }

    private void setInitialPitchYaw() {
        Direction facing = (Direction)this.f_19853_.m_8055_(this.m_20183_()).m_61143_((Property)ScryerCrystal.FACING);
        if (facing == Direction.NORTH) {
            this.m_146922_(180.0f);
        } else if (facing == Direction.WEST) {
            this.m_146922_(90.0f);
        } else if (facing == Direction.SOUTH) {
            this.m_146922_(0.0f);
        } else if (facing == Direction.EAST) {
            this.m_146922_(270.0f);
        } else if (facing == Direction.DOWN) {
            this.m_146926_(75.0f);
        }
    }

    protected boolean m_6093_() {
        return false;
    }

    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            if (this.screenshotSoundCooldown > 0) {
                --this.screenshotSoundCooldown;
            }
            if (this.redstoneCooldown > 0) {
                --this.redstoneCooldown;
            }
            if (this.toggleNightVisionCooldown > 0) {
                --this.toggleNightVisionCooldown;
            }
        } else if (this.f_19853_.m_8055_(this.m_20183_()).m_60734_() != BlockRegistry.SCRYERS_CRYSTAL.get()) {
            this.m_146870_();
        }
    }

    public float getZoomAmount() {
        return this.zoomAmount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCameraDown() {
        BlockEntity var2 = this.f_19853_.m_7702_(this.m_20183_());
        if (!(var2 instanceof ScryerCrystalTile)) return false;
        ScryerCrystalTile cam = (ScryerCrystalTile)var2;
        if (!cam.down) return false;
        return true;
    }

    public void setRotation(float yaw, float pitch) {
        this.m_19915_(yaw, pitch);
    }

    public void stopViewing(ServerPlayer player) {
        if (!this.f_19853_.f_46443_) {
            this.discardCamera();
            player.f_8926_ = player;
            Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketSetCameraView((Entity)player));
        }
    }

    public void discardCamera() {
        if (!this.f_19853_.f_46443_) {
            BlockEntity blockEntity = this.f_19853_.m_7702_(this.m_20183_());
            if (blockEntity instanceof ICameraMountable) {
                ICameraMountable camMount = (ICameraMountable)blockEntity;
                camMount.stopViewing();
            }
            SectionPos chunkPos = SectionPos.m_123199_((BlockPos)this.m_20183_());
            int view = this.viewDistance <= 0 ? this.f_19853_.m_7654_().m_6846_().m_11312_() : this.viewDistance;
            for (int x = chunkPos.m_123341_() - view; x <= chunkPos.m_123341_() + view; ++x) {
                for (int z = chunkPos.m_123343_() - view; z <= chunkPos.m_123343_() + view; ++z) {
                    ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.f_19853_), (String)"ars_nouveau", (Entity)this, (int)x, (int)z, (boolean)false, (boolean)false);
                }
            }
        }
        this.m_146870_();
    }

    public void setHasLoadedChunks(int initialViewDistance) {
        this.loadedChunks = true;
        this.viewDistance = initialViewDistance;
    }

    public boolean hasLoadedChunks() {
        return this.loadedChunks;
    }

    protected void m_8097_() {
    }

    public void m_7380_(CompoundTag tag) {
    }

    public void m_7378_(CompoundTag tag) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean m_142389_() {
        return true;
    }
}

