/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.mana.IManaDiscountEquipment;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.NotEnoughManaPacket;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CasterTome
extends ModItem
implements ICasterTool,
IManaDiscountEquipment {
    public CasterTome(Item.Properties properties) {
        super(properties);
    }

    public CasterTome() {
    }

    @Override
    public boolean onScribe(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack tableStack) {
        return player.m_7500_() && ICasterTool.super.onScribe(world, pos, player, handIn, tableStack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        ISpellCaster caster = this.getSpellCaster(stack);
        Spell spell = caster.getSpell();
        return caster.castSpell(worldIn, (LivingEntity)playerIn, handIn, (Component)Component.m_237119_(), spell);
    }

    @Override
    @NotNull
    public ISpellCaster getSpellCaster(ItemStack stack) {
        return new TomeSpellCaster(stack);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip2, TooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        ISpellCaster caster = this.getSpellCaster(stack);
        Spell spell = caster.getSpell();
        this.getInformation(stack, worldIn, tooltip2, flagIn);
        tooltip2.add((Component)Component.m_237115_((String)"tooltip.ars_nouveau.caster_tome"));
        super.m_7373_(stack, worldIn, tooltip2, flagIn);
    }

    @Override
    public int getManaDiscount(ItemStack i, Spell spell) {
        return spell.getCost() / 2;
    }

    public static class TomeSpellCaster
    extends SpellCaster {
        public TomeSpellCaster(ItemStack stack) {
            super(stack);
        }

        @Override
        public SpellResolver getSpellResolver(SpellContext context, Level worldIn, LivingEntity playerIn, InteractionHand handIn) {
            return new SpellResolver(context){

                @Override
                protected boolean enoughMana(LivingEntity entity) {
                    Player player;
                    boolean canCast;
                    int totalCost = this.getResolveCost();
                    IManaCap manaCap = (IManaCap)CapabilityRegistry.getMana(entity).orElse(null);
                    if (manaCap == null) {
                        return false;
                    }
                    boolean bl = canCast = (double)totalCost <= manaCap.getCurrentMana() || manaCap.getCurrentMana() == (double)manaCap.getMaxMana() || entity instanceof Player && (player = (Player)entity).m_7500_();
                    if (!(canCast || entity.m_20193_().f_46443_ || this.silent)) {
                        PortUtil.sendMessageNoSpam((Entity)entity, (Component)Component.m_237115_((String)"ars_nouveau.spell.no_mana"));
                        if (entity instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)entity;
                            Networking.sendToPlayerClient(new NotEnoughManaPacket(totalCost), serverPlayer);
                        }
                    }
                    return canCast;
                }
            };
        }
    }
}

