/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.util.Utils;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DebugRendererExtensions {
    private static final Set<Renderers> EMPTY = ImmutableSet.of();

    @OnlyIn(value=Dist.CLIENT)
    public static Set<Renderers> getEnabledRenderers() {
        if (!Utils.isDevEnv()) {
            return EMPTY;
        }
        return ImmutableSet.of();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double camX, double camY, double camZ) {
        for (Renderers renderer : DebugRendererExtensions.getEnabledRenderers()) {
            renderer.getRenderer().m_7790_(poseStack, (MultiBufferSource)bufferSource, camX, camY, camZ);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Renderers {
        PATHFINDING(d -> d.f_113413_),
        WATER(d -> d.f_113414_),
        HEIGHT_MAP(d -> d.f_113416_),
        COLLISION_BOX(d -> d.f_113417_),
        NEIGHBORS_UPDATE(d -> d.f_113418_),
        STRUCTURE(d -> d.f_113420_),
        LIGHT(d -> d.f_113421_),
        WORLD_GEN_ATTEMPT(d -> d.f_113422_),
        SOLID_FACE(d -> d.f_113423_),
        CHUNK(d -> d.f_113424_),
        BRAIN(d -> d.f_113425_),
        VILLAGE_SECTIONS(d -> d.f_113426_),
        BEE(d -> d.f_113427_),
        RAID(d -> d.f_113428_),
        GOAL_SELECTOR(g -> g.f_113429_),
        GAME_TEST(g -> g.f_113430_),
        GAME_EVENT(g -> g.f_173815_);

        private final Function<DebugRenderer, DebugRenderer.SimpleDebugRenderer> rendererSupplier;

        private Renderers(Function<DebugRenderer, DebugRenderer.SimpleDebugRenderer> rendererSupplier) {
            this.rendererSupplier = rendererSupplier;
        }

        public DebugRenderer.SimpleDebugRenderer getRenderer() {
            return this.rendererSupplier.apply(Minecraft.m_91087_().f_91064_);
        }
    }
}

